<?php
// Inicjalizacja obiektu JSON
require_once 'Services/JSON.php';
$json = new Services_JSON();

$results = array();
$q = isset($_GET['q']) ? $_GET['q'] : '';

// Poczenie z baz danych opisan w rozdziale 10
$db = new PDO('sqlite:/usr/local/data/zodiac.db');

// Przesanie zapytania
$st = $db->prepare('SELECT sign FROM zodiac WHERE planet LIKE ? ');
$st->execute(array($q.'%'));

// Utworzenie tablicy wynikw
while ($row = $st->fetch()) {
    $results[] = $row['sign'];
}

// Elementy zapobiegajce buforowaniu danych
header("Expires: 0");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
// Opcje charakterystyczne dla oprogramowania IE
header("Cache-Control: post-check=0, pre-check=0", false);
// Opcje HTTP/1.0
header("Pragma: no-cache");

// Odpowiedzi s dane JSON
header('Content-Type: application/json');

// Przekazanie danych JSON
print $json->encode($results);
?>
